// index.js
import bleTool from '../../SUPVANAPIT50PRO/BLETool.js'
import bleToothManage from '../../SUPVANAPIT50PRO/BLEToothManage.js'
import constants from '../../SUPVANAPIT50PRO/Constants.js'
Page({
  data: {
    blueList: [{}], //搜索到的蓝牙列表
    templateWidth: 560,//模版宽度
    templateHeight: 302,//模版高度
    barCodeWidth: 214,//条码宽度
    barCodeHeight: 72,//条码高度
    qrCodeWidth: 20,//二维码宽度
    qrCodeHeight: 20,//二维码高度
    pixelRatio: 2,//像素比
    canvasBarCode: null,//条码canvas
    canvasText: null,//文本canvas
    printCopies: 0,//打印份数
    printNum: 0,//当前打印的份数
    //字模数据组成格式
    PageObject: [{
      "Width": 50,
      "Height": 30,
      "Rotate": "1",
      "Copies": "1",
      "Density": 4,
      "HorizontalNum": 0,
      "VerticalNum": 0,
      "PaperType": 1,
      "Gap": 3,
      "DeviceSn": "T0024B",
      "CutType": 2,
      "SavePaper": false,
      "FirstCut": 0,
      "PreviewPath": 'https://sjpt.issas.ac.cn/profile/upload/Template/202502271300003.jpg',
      "ImageWidth": 50,
      "ImageHeight": 50,
      "Margin": 2,
      "Speed": 30,
      "DrawObjects": [
        // {
        //   "AntiColor": false,
        //   "X": 0,
        //   "Y": 0,
        //   "Width": 30,
        //   "Height": 40,
        //   "Content": "https://resource-supvan.oss-cn-qingdao.aliyuncs.com/upload/Template/System/T/34574.png",
        //   "FontName": "黑体",
        //   "FontStyle": 0,
        //   "Align": 1,
        //   "FontSize": null,
        //   "AutoReturn": false,
        //   "Format": "IMAGE",
        //   "X1": 67,
        //   "Y1": 48,
        //   "Orientation": 2,
        //   "expanded": true // 用于控制是否展开显示
        // },
        {
          "AntiColor": false,
          "X": 0,
          "Y": 0,
          "Width": 30,
          "Height": 4,
          "Content": "文本内容",
          "FontName": "黑体",
          "FontStyle": 0,
          "Align": 1,
          "FontSize": 4,
          "AutoReturn": false,
          "Format": "TEXT",
          "X1": 67,
          "Y1": 48,
          "Orientation": 0,
        },
        {
          "AntiColor": false,
          "X": 10,
          "Y": 0,
          "Width": 30,
          "Height": 10,
          "Content": "文本内容1",
          "FontName": "黑体",
          "FontStyle": 0,
          "Align": 1,
          "FontSize": 4,
          "AutoReturn": false,
          "Format": "TEXT",
          "X1": 67,
          "Y1": 48,
          "Orientation": 0,
        },
        // {
        //   "AntiColor": false,
        //   "X": 5,
        //   "Y": 10,
        //   "Width": 30,
        //   "Height": 30,
        //   "Content": "二维码内容",
        //   "FontName": "黑体",
        //   "FontStyle": 0,
        //   "Align": 1,
        //   "FontSize": null,
        //   "AutoReturn": false,
        //   "Format": "QRCODE",
        //   "X1": 30,
        //   "Y1": 18,
        //   "Orientation": 2
        // },
        // {
        //   "AntiColor": false,
        //   "X": 5,
        //   "Y": 50,
        //   "Width": 30,
        //   "Height": 9,
        //   "Content": "6903244679763",
        //   "FontName": "黑体",
        //   "FontStyle": 0,
        //   "Align": 1,
        //   "FontSize": 4,
        //   "AutoReturn": false,
        //   "Format": "BARCODE",
        //   "Orientation": 2,
        // }

      ],
      "Direction": 1
    }],
    PageImageObject: [{
      "Width": 50,
      "Height": 70,
      "Rotate": 1,
      "Copies": 1,
      "Density": 6,
      "HorizontalNum": 0,
      "VerticalNum": 0,
      "PaperType": 1,
      "Gap": 3,
      "DeviceSn": 'T0100A2305163367',
      "ImageUrl": 'https://resource-supvan.oss-cn-qingdao.aliyuncs.com/upload/Template/System/T/34574.png',
      "ImageWidth": 50, //图片宽（单位mm）
      "ImageHeight": 70, //图片高（单位mm）
      "Speed": 60,
    },
      // {
      // 	"Width": 50,
      // 	"Height": 30,
      // 	"Rotate": 1,
      // 	"Copies": 1,
      // 	"Density": 4,
      // 	"HorizontalNum": 0,
      // 	"VerticalNum": 0,
      // 	"PaperType": 3,
      // 	"Gap": 8,
      // 	"DeviceSn": 'T0100A2305163367',
      // 	"ImageUrl": 'https://resource-supvan.oss-cn-qingdao.aliyuncs.com/upload/Template/System/T/34574.png',
      // 	"ImageWidth": 50, //图片宽（单位mm）
      // 	"ImageHeight": 30, //图片高（单位mm）
      // }
    ],
  },
  /**
   * 页面加载时的生命周期函数
   * 设置导航栏标题，初始化像素比、条码 canvas 和文本 canvas
   * @CallIn 页面初次加载时自动调用
   * @CallOut 无
   */
  onLoad() {
    wx.setNavigationBarTitle({
      title: '微信小程序SDK客户版本',
    })
    this.setData({
      pixelRatio: wx.getWindowInfo().pixelRatio,
      canvasText: wx.createCanvasContext('Canvas', this),
      canvasBarCode: wx.createSelectorQuery().in(this),
    })

  },
  /**
   * 
   * 启动搜索蓝牙并将搜索到的蓝牙信息存到集合 blueList 里面
   * @CallIn index.wxml 中触发点击开始蓝牙搜索按钮点击事件
   * @CallOut bleTool.scanBleDeviceList
   */
  clickStartScanBleDevice() {
    const that = this
    that.data.blueList = []//清空集合
    //bleTool.setCustomType(true)
    bleTool.scanBleDeviceList((res) => {
      console.log('搜索到的蓝牙设备:', res);
      if (res.ResultCode == 0) {
        if (res && res.ResultValue && res.ResultValue.devices[0]) {
          that.data.blueList.push(res.ResultValue.devices[0])
          that.setData({
            //blueList: [...[], res.ResultValue.devices[0]]
            blueList: that.data.blueList
          })
        }
      }
    }).catch(error => {
      console.log('搜索蓝牙设备失败:', error);
    })
  },
  /**
   * 停止搜索蓝牙
   * CallIn:index.wxml 中触发点击停止蓝牙搜索按钮点击事件
   * CallOut:BLETool.stopScanBleDevices
   */
  clickStopScanBleDevices() {
    bleTool.stopScanBleDevices().then(res => {
      console.log(res)
      wx.showToast({
        title: '停止搜索蓝牙设备成功',
        icon: 'none'
      })
    }).catch(error => {
      console.log('停止搜索蓝牙设备失败:', error);
    })
  },
  /**
   * 连接蓝牙设备
   * @param {object} elment 事件对象(包含触发事件时的相关信息)
   * @CallIn index.wxml 中触发点击搜索到的蓝牙名称按钮点击事件
   * @CallOut bleTool.connectBleDevice
   */
  clickConnectBleDevice(elment) {
    const that = this
    const index = elment.currentTarget.dataset.index//获取当前点击蓝牙列表的下标
    const deviceName = that.data.blueList[index].name//获取当前点击蓝牙列表的名字
    that.data.PageObject.forEach(objectdata => objectdata.DeviceSn = deviceName)
    that.data.PageImageObject.forEach(objectdataImg => objectdataImg.DeviceSn = deviceName)
    bleTool.connectBleDevice(that.data.blueList[index]).then(res => {
      console.log(res)
      wx.showToast({
        title: '连接蓝牙设备成功',
        icon: 'none'
      })
    }).catch(error => {
      console.log(error);
    })
  },

  /**
   * 断开蓝牙
   * @CallIn index.wxml 中触发点击断开蓝牙按钮点击事件
   * @CallOut bleTool.disconnectBleDevice
   */
  clickDisconnectBleDevice() {
    bleTool.disconnectBleDevice().then(res => {
      console.log(res);
    }).catch(err => {
      console.log(err);
    })
  },
  /**
   * 打印示例模板
   * @CallIn index.wxml 中触发点击开始打印示例字模的按钮点击事件
   * @CallOut BLEToothManage.doPrintMatrix
   */
  clickStartPrintTemplatePageObjectLocal() {
    console.log('this.data.PageObject', this.data.PageObject)
    bleToothManage.doPrintMatrix(this.data.canvasText, this.data.PageObject, this.data.canvasBarCode, res => {
      console.log('数据回调', res)
      if (res.ResultCode == constants.globalResultCode.ResultCode100) {
        let resultValue = res.ResultValue
        this.setData({
          templateWidth: resultValue.width,
          templateHeight: resultValue.height,
          barCodeWidth: resultValue.barcodeWidth,
          barCodeHeight: resultValue.barcodeHeight,
          qrCodeWidth: resultValue.qrcodeWidth,
          qrCodeHeight: resultValue.qrcodeHeight,
        })
      } else {
        wx.showToast({
          title: '全部打印完成',
        })
      }

    }).catch(error => { console.log('打印失败', error) })
  },
  /**
   * 打印图片
   * @CallIn index.wxml 中触发点击开启打印图片的按钮点击事件
   * @CallOut BLEToothManage.js 里面 doPrintImage
   */
  clickStartPrintTemplatePageImageLocal() {
    console.log('打印图片', JSON.stringify(this.data.PageImageObject))
    bleToothManage.doPrintImage(this.data.canvasText, this.data.PageImageObject, res => {
      console.log('打印图片回调', res)
      if (res.ResultCode == 100) {
        let resultValue = res.ResultValue
        this.setData({
          templateWidth: resultValue.width,
          templateHeight: resultValue.height,
        })
      }
    }).catch(error => {
      console.log('打印图片失败', error)
    })
  },
  /**
   * 绘制预览图
   * @CallIn index.wxml 中触发点击开始绘制预览图的按钮点击事件
   * @CallOut BLEToothManage.js 里面 doDrawPreview
   */
  clickStartDrawPreview() {
    console.log('预览图片')
    bleToothManage.doDrawPreview(this.data.canvasText, this.data.PageObject, this.data.canvasBarCode, res => {
      if (res.ResultCode == constants.globalResultCode.ResultCode100) {
        console.log('预览图尺寸:', res);
        let resultValue = res.ResultValue
        this.setData({
          templateWidth: resultValue.width,
          templateHeight: resultValue.height,
          barCodeWidth: resultValue.barcodeWidth,
          barCodeHeight: resultValue.barcodeHeight,
          qrCodeWidth: resultValue.qrcodeWidth,
          qrCodeHeight: resultValue.qrcodeHeight,
        })
      } else if (res.ResultCode == constants.globalResultCode.ResultCodeSuccess) {
        console.log('预览图集合:', res);
        wx.saveImageToPhotosAlbum({
          filePath: res.ResultValue.previewList[0],
          success: () => { },
          fail: err => {
            console.log(err);
          },
          complete: () => { }
        });
      }
    }).catch(error => { console.error(error) })
  },
  /**
   * 终止打印
   * @CallIn index.wxml 中触发点击终止打印的按钮点击事件
   * @CallOut BLEToothManage.js 里面 onStopPrint
   */
  clickStopPrint() {
    bleTool.stopPrint(res => {
      console.log('终止打印回调', res)
    }).catch(error => { console.error(error) })
  },
  /**
   * 输入打印份数
   * @param {object} e 事件对象，包含输入框的输入值
   * @CallIn index.wxml 中输入框输入内容时触发
   * @CallOut 无
   */
  startEnterPrintCopies(e) {
    console.log('打印份数', e.detail.value);
    const copies = e.detail.value
    this.setData({
      'PageObject[0].Copies': copies,
      'PageImageObject[0].Copies': copies
    });
  },
  /**
   * 获取耗材信息
   * @CallIn index.wxml 中点击获取耗材信息时触发
   * @CallOut 无
   */
  clickConsumableInformation() {
    console.log('获取耗材信息');
    bleToothManage.ConsumableInformation().then(res => {
      console.log('res', res);
      wx.showToast({
        duration: 2000,
        title: JSON.stringify(res),
        mask: true,
        success: (res) => { },
        fail: (res) => { },
        complete: (res) => { },
      })
    }).catch(err => {
      console.log(err);
    })
  },
})

